import { z, ZodType } from 'zod';

export class FooterValidation {
  static readonly CREATE: ZodType = z.object({
    name: z.string({ message: 'Nama harus diisi' }),
    type: z.string({ message: 'Tipe harus diisi' }),
    order: z.number({ message: 'Order harus diisi' }),
  });

  static readonly UPDATE: ZodType = z.object({
    name: z.string({ message: 'Nama harus diisi' }),
  });

  static readonly CREATE_ITEM: ZodType = z.object({
    name: z.string({ message: 'Nama harus diisi' }),
    url: z.string({ message: 'URL harus diisi' }),
  });

  static readonly UPDATE_ITEM: ZodType = z.object({
    name: z.string({ message: 'Nama harus diisi' }),
    url: z.string({ message: 'URL harus diisi' }),
  });

  static readonly UPDATE_ORDER: ZodType = z.array(
    z.object({
      id: z.string({ message: 'ID harus diisi' }),
      order: z.number({ message: 'Order harus diisi' }),
    })
  );
}
