import { User, toUserResponse, UserResponse } from './user-model';

export type MitraPackageOrder = {
  id: string;
  user_id: string;
  mitra_package_id: string;
  created_at: Date;
  updated_at: Date;
};

export type MitraPackageOrderResponse = {
  id: string;
  user: UserResponse;
  mitra_package_id: string;
  per_pax_price_double: number;
  per_pax_price_triple: number;
  per_pax_price_quad: number;
  created_at: Date;
  updated_at: Date;
};

export type CreateMitraPackageOrderRequest = {
  mitra_package_id: string;
};

export type MitraPackageOrderQueryParams = {
  search?: string;
  sort?: string;
  order?: 'asc' | 'desc';
  page: number;
  limit: number;
};

export function toMitraPackageOrderResponse(
  order: MitraPackageOrder & {
    User: User;
    MitraPackage: { per_pax_price_double: number; per_pax_price_triple: number; per_pax_price_quad: number };
  }
): MitraPackageOrderResponse {
  return {
    id: order.id,
    user: toUserResponse(order.User),
    mitra_package_id: order.mitra_package_id,
    per_pax_price_double: Number(order.MitraPackage.per_pax_price_double),
    per_pax_price_triple: Number(order.MitraPackage.per_pax_price_triple),
    per_pax_price_quad: Number(order.MitraPackage.per_pax_price_quad),
    created_at: order.created_at,
    updated_at: order.updated_at,
  };
}
