export type MenuItem = {
  id: string;
  name: string;
  url: string;
  visible: boolean;
  created_at: Date;
  updated_at: Date;
};

export type MenuItemResponse = {
  id: string;
  name: string;
  url: string;
  visible: boolean;
  created_at: Date;
  updated_at: Date;
};

export type CreateMenuItemRequest = {
  name: string;
  url: string;
};

export type UpdateMenuItemRequest = {
  name: string;
  url: string;
};

export function toMenuItemResponse(menuItem: MenuItem): MenuItemResponse {
  return {
    id: menuItem.id,
    name: menuItem.name,
    url: menuItem.url,
    visible: menuItem.visible,
    created_at: menuItem.created_at,
    updated_at: menuItem.updated_at,
  };
}
