export type Faq = {
  id: string;
  question: string;
  answer: string;
  created_at: Date;
  updated_at: Date;
}

export type FaqResponse = {
  id: string;
  question: string;
  answer: string;
  created_at: Date;
  updated_at: Date;
};

export type CreateFaqRequest = {
  question: string;
  answer: string;
};

export type UpdateFaqRequest = CreateFaqRequest;

export function toFaqResponse(faq: Faq): FaqResponse {
  return {
    id: faq.id,
    question: faq.question,
    answer: faq.answer,
    created_at: faq.created_at,
    updated_at: faq.updated_at,
  };
}