export type ContentType = 'TEXT' | 'IMAGE' | 'BUTTON' | 'BENEFIT_CARD';

export type Color = {
  id: string;
  name: string;
  hex: string;
  created_at: Date;
  updated_at: Date;
};

export type Content = {
  id: string;
  page: string;
  section: string;
  type: ContentType;
  key: string;
  value: any;
  visible: boolean;
  created_at: Date;
  updated_at: Date;
};

export type ContentResponse = {
  id: string;
  page: string;
  section: string;
  type: ContentType;
  key: string;
  value: any;
  visible: boolean;
  created_at: Date;
  updated_at: Date;
};

type ButtonValue = {
  text: string;
  url: string;
};

type BenefitCardValue = {
  title: string;
  description: string;
};

type ContentValue = string | ButtonValue | BenefitCardValue;

export type CreateContentRequest = {
  page: string;
  section: string;
  type: ContentType;
  key: string;
  value: ContentValue;
};

export type UpdateContentRequest = CreateContentRequest;

export type UpdateContentValueRequest = {
  value: ContentValue;
};

export function toContentResponse(content: Content): ContentResponse {
  return {
    id: content.id,
    page: content.page,
    section: content.section,
    type: content.type,
    key: content.key,
    value: JSON.parse(content.value),
    visible: Boolean(content.visible),
    created_at: content.created_at,
    updated_at: content.updated_at,
  };
}

export type ColorResponse = {
  id: string;
  name: string;
  hex: string;
  created_at: Date;
  updated_at: Date;
};

export type CreateColorRequest = {
  name: string;
  hex: string;
};

export type UpdateColorRequest = {
  id: string;
  hex: string;
};

export function toColorResponse(color: Color): ColorResponse {
  return {
    id: color.id,
    name: color.name,
    hex: color.hex,
    created_at: color.created_at,
    updated_at: color.updated_at,
  };
}
