import { NextFunction, Request, Response } from 'express';
import { FooterService } from '../service/footer-service';
import {
  CreateFooterRequest,
  UpdateFooterRequest,
  CreateFooterItemRequest,
  UpdateFooterItemRequest,
  UpdateFooterOrderRequest,
} from '../model/footer-model';

export class FooterController {
  static async create(req: Request, res: Response, next: NextFunction) {
    try {
      const request: CreateFooterRequest = req.body as CreateFooterRequest;
      const response = await FooterService.create(request);

      res.status(201).json({
        success: true,
        message: 'Footer created successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async getAll(req: Request, res: Response, next: NextFunction) {
    try {
      const response = await FooterService.getAll();

      res.status(200).json({
        success: true,
        message: 'Footers retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async get(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const response = await FooterService.get(id);

      res.status(200).json({
        success: true,
        message: 'Footer retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async update(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const request: UpdateFooterRequest = req.body as UpdateFooterRequest;
      const response = await FooterService.update(id, request);

      res.status(200).json({
        success: true,
        message: 'Footer updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async updateVisibility(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const visible = req.body.visible;
      const response = await FooterService.updateVisibility(id, visible);

      res.status(200).json({
        success: true,
        message: 'Footer visibility updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async updateOrder(req: Request, res: Response, next: NextFunction) {
    try {
      const request: UpdateFooterOrderRequest[] = req.body as UpdateFooterOrderRequest[];
      await FooterService.updateOrder(request);

      res.status(200).json({
        success: true,
        message: 'Footer order updated successfully',
      });
    } catch (error) {
      next(error);
    }
  }

  static async delete(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      await FooterService.delete(id);

      res.status(200).json({
        success: true,
        message: 'Footer deleted successfully',
      });
    } catch (error) {
      next(error);
    }
  }

  static async createItem(req: Request, res: Response, next: NextFunction) {
    try {
      const footerId = req.params.footerId;
      const request: CreateFooterItemRequest = req.body as CreateFooterItemRequest;
      const response = await FooterService.createItem(footerId, request);

      res.status(201).json({
        success: true,
        message: 'Footer item created successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async updateItem(req: Request, res: Response, next: NextFunction) {
    try {
      const footerId = req.params.footerId;
      const itemId = req.params.itemId;
      const request: UpdateFooterItemRequest = req.body as UpdateFooterItemRequest;
      const response = await FooterService.updateItem(footerId, itemId, request);

      res.status(200).json({
        success: true,
        message: 'Footer item updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async updateItemVisibility(req: Request, res: Response, next: NextFunction) {
    try {
      const footerId = req.params.footerId;
      const itemId = req.params.itemId;
      const visible = req.body.visible;
      const response = await FooterService.updateItemVisibility(footerId, itemId, visible);

      res.status(200).json({
        success: true,
        message: 'Footer item visibility updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async deleteItem(req: Request, res: Response, next: NextFunction) {
    try {
      const footerId = req.params.footerId;
      const itemId = req.params.itemId;
      await FooterService.deleteItem(footerId, itemId);

      res.status(200).json({
        success: true,
        message: 'Footer item deleted successfully',
      });
    } catch (error) {
      next(error);
    }
  }
}
