import { NextFunction, Request, Response } from 'express';
import { FaqService } from '../service/faq-service';
import { CreateFaqRequest, UpdateFaqRequest } from '../model/faq-model';

export class FaqController {
  static async create(req: Request, res: Response, next: NextFunction) {
    try {
      const request: CreateFaqRequest = req.body as CreateFaqRequest;
      const response = await FaqService.create(request);

      res.status(201).json({
        success: true,
        message: 'Faq created successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async getAll(req: Request, res: Response, next: NextFunction) {
    try {
      const response = await FaqService.getAll();

      res.status(200).json({
        success: true,
        message: 'Faqs retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async get(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const response = await FaqService.get(id);

      res.status(200).json({
        success: true,
        message: 'Faq retrieved successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async update(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      const request: UpdateFaqRequest = req.body as UpdateFaqRequest;
      const response = await FaqService.update(id, request);

      res.status(200).json({
        success: true,
        message: 'Faq updated successfully',
        data: response,
      });
    } catch (error) {
      next(error);
    }
  }

  static async delete(req: Request, res: Response, next: NextFunction) {
    try {
      const id = req.params.id;
      await FaqService.delete(id);

      res.status(200).json({
        success: true,
        message: 'Faq deleted successfully',
      });
    } catch (error) {
      next(error);
    }
  }
}