"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert = require("assert");
const node_test_1 = require("node:test");
const native_js_1 = require("../native.js");
const v4_js_1 = require("../v4.js");
const randomBytesFixture = Uint8Array.of(0x10, 0x91, 0x56, 0xbe, 0xc4, 0xfb, 0xc1, 0xea, 0x71, 0xb4, 0xef, 0xe1, 0x67, 0x1c, 0x58, 0x36);
const expectedBytes = Uint8Array.of(16, 145, 86, 190, 196, 251, 65, 234, 177, 180, 239, 225, 103, 28, 88, 54);
(0, node_test_1.describe)('v4', () => {
    (0, node_test_1.default)('subsequent UUIDs are different', () => {
        const id1 = (0, v4_js_1.default)();
        const id2 = (0, v4_js_1.default)();
        assert.ok(id1 !== id2);
    });
    (0, node_test_1.default)('should uses native randomUUID() if no option is passed', async () => {
        const mock = (await Promise.resolve().then(() => require('node:test'))).default.mock;
        if (!mock) {
            return;
        }
        const mockRandomUUID = mock.method(native_js_1.default, 'randomUUID');
        assert.equal(mockRandomUUID.mock.callCount(), 0);
        (0, v4_js_1.default)();
        assert.equal(mockRandomUUID.mock.callCount(), 1);
        mock.restoreAll();
    });
    (0, node_test_1.default)('should not use native randomUUID() if an option is passed', async () => {
        const mock = (await Promise.resolve().then(() => require('node:test'))).default.mock;
        if (!mock) {
            return;
        }
        const mockRandomUUID = mock.method(native_js_1.default, 'randomUUID');
        assert.equal(mockRandomUUID.mock.callCount(), 0);
        (0, v4_js_1.default)({});
        assert.equal(mockRandomUUID.mock.callCount(), 0);
        mock.restoreAll();
    });
    (0, node_test_1.default)('explicit options.random produces expected result', () => {
        const id = (0, v4_js_1.default)({ random: randomBytesFixture });
        assert.strictEqual(id, '109156be-c4fb-41ea-b1b4-efe1671c5836');
    });
    (0, node_test_1.default)('explicit options.rng produces expected result', () => {
        const id = (0, v4_js_1.default)({ rng: () => randomBytesFixture });
        assert.strictEqual(id, '109156be-c4fb-41ea-b1b4-efe1671c5836');
    });
    (0, node_test_1.default)('fills one UUID into a buffer as expected', () => {
        const buffer = new Uint8Array(16);
        const result = (0, v4_js_1.default)({ random: randomBytesFixture }, buffer);
        assert.deepEqual(buffer, expectedBytes);
        assert.strictEqual(buffer, result);
    });
    (0, node_test_1.default)('fills two UUIDs into a buffer as expected', () => {
        const buffer = new Uint8Array(32);
        (0, v4_js_1.default)({ random: randomBytesFixture }, buffer, 0);
        (0, v4_js_1.default)({ random: randomBytesFixture }, buffer, 16);
        const expectedBuf = new Uint8Array(32);
        expectedBuf.set(expectedBytes);
        expectedBuf.set(expectedBytes, 16);
        assert.deepEqual(buffer, expectedBuf);
    });
});
//# sourceMappingURL=data:application/json;base64,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