"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserValidation = void 0;
const zod_1 = require("zod");
class UserValidation {
}
exports.UserValidation = UserValidation;
UserValidation.CREATE = zod_1.z.object({
    full_name: zod_1.z
        .string({ required_error: 'Nama lengkap tidak boleh kosong' })
        .min(3, 'Nama lengkap minimal 3 karakter')
        .max(100, 'Nama lengkap maksimal 100 karakter'),
    email: zod_1.z.string({ required_error: 'Email tidak boleh kosong' }).email('Email tidak valid'),
    whatsapp_number: zod_1.z
        .string({ required_error: 'Nomor WhatsApp tidak boleh kosong' })
        .min(10, 'Nomor WhatsApp tidak valid')
        .max(15, 'Nomor WhatsApp tidak valid'),
    password: zod_1.z.string({ required_error: 'Password tidak boleh kosong' }).min(6, 'Password minimal 6 karakter'),
    role: zod_1.z.string().optional(),
});
UserValidation.QUERY = zod_1.z.object({
    full_name: zod_1.z.string().optional(),
    email: zod_1.z.string().email().optional(),
    whatsapp_number: zod_1.z.string().min(10).max(15).optional(),
    role: zod_1.z.string().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
UserValidation.UPDATE_CURRENT = zod_1.z.object({
    full_name: zod_1.z
        .string()
        .min(3, 'Nama lengkap minimal 3 karakter')
        .max(100, 'Nama lengkap maksimal 100 karakter')
        .optional(),
    email: zod_1.z.string().email('Email tidak valid').optional(),
    whatsapp_number: zod_1.z.string().min(10, 'Nomor WhatsApp tidak valid').max(15, 'Nomor WhatsApp tidak valid').optional(),
});
UserValidation.UPDATE = zod_1.z.object({
    full_name: zod_1.z
        .string()
        .min(3, 'Nama lengkap minimal 3 karakter')
        .max(100, 'Nama lengkap maksimal 100 karakter')
        .optional(),
    email: zod_1.z.string().email('Email tidak valid').optional(),
    whatsapp_number: zod_1.z.string().min(10, 'Nomor WhatsApp tidak valid').max(15, 'Nomor WhatsApp tidak valid').optional(),
    role: zod_1.z.string().optional(),
});
UserValidation.UPDATE_PASSWORD = zod_1.z.object({
    old_password: zod_1.z
        .string({ required_error: 'Password lama tidak boleh kosong' })
        .min(1, 'Password lama tidak boleh kosong'),
    new_password: zod_1.z
        .string({
        required_error: 'Password baru tidak boleh kosong',
    })
        .min(6, 'Password minimal 6 karakter')
        .max(100, 'Password maksimal 100 karakter'),
});
