"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPackageValidation = void 0;
const zod_1 = require("zod");
class UserPackageValidation {
}
exports.UserPackageValidation = UserPackageValidation;
UserPackageValidation.CREATE = zod_1.z.object({
    number_of_pax: zod_1.z.number().int({ message: 'Jumlah pax harus integer' }).positive('Jumlah pax harus positif'),
    travel_duration: zod_1.z
        .number()
        .int({ message: 'Durasi perjalanan harus integer' })
        .positive('Durasi perjalanan harus positif'),
    mekkah_duration: zod_1.z
        .number()
        .int({ message: 'Durasi di Mekkah harus integer' }),
    madinah_duration: zod_1.z
        .number()
        .int({ message: 'Durasi di Madinah harus integer' }),
    transportation_id: zod_1.z.string({ message: 'Transportasi harus diisi' }),
    flight_id: zod_1.z.string({ message: 'Tiket pesawat harus diisi' }),
    hotel_mekkah_id: zod_1.z.string({ message: 'Hotel di Mekkah harus diisi' }),
    hotel_madinah_id: zod_1.z.string({ message: 'Hotel di Madinah harus diisi' }),
    muthawif_id: zod_1.z.string({ message: 'Muthawif harus diisi' }),
    handling_id: zod_1.z.string({ message: 'Handling harus diisi' }),
});
