"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPackageOrderValidation = void 0;
const zod_1 = require("zod");
class UserPackageOrderValidation {
}
exports.UserPackageOrderValidation = UserPackageOrderValidation;
UserPackageOrderValidation.CREATE = zod_1.z.object({
    full_name: zod_1.z.string({ message: 'Nama lengkap harus diisi' }),
    email: zod_1.z.string({ message: 'Email harus diisi' }).email({ message: 'Email tidak valid' }),
    whatsapp_number: zod_1.z
        .string({ message: 'Nomor WhatsApp harus diisi' })
        .min(10, { message: 'Nomor WhatsApp tidak valid' })
        .max(15, { message: 'Nomor WhatsApp tidak valid' }),
    user_package_id: zod_1.z.string({ message: 'ID paket harus diisi' }),
});
UserPackageOrderValidation.QUERY = zod_1.z.object({
    search: zod_1.z.string().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
