"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraRequestValidation = void 0;
const zod_1 = require("zod");
class MitraRequestValidation {
}
exports.MitraRequestValidation = MitraRequestValidation;
MitraRequestValidation.CREATE = zod_1.z.object({
    ktp: zod_1.z.string({ message: 'KTP harus diisi' }),
    upgrade_amount: zod_1.z.number().int({ message: 'Jumlah upgrade harus diisi' }),
    payment_proof: zod_1.z.string({ message: 'Bukti pembayaran harus diisi' }),
});
MitraRequestValidation.QUERY = zod_1.z.object({
    search: zod_1.z.string().optional(),
    status: zod_1.z.string().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
MitraRequestValidation.UPDATE_STATUS = zod_1.z.object({
    status: zod_1.z.string().refine((value) => ['PENDING', 'APPROVED', 'REJECTED'].includes(value), {
        message: 'Status harus PENDING, APPROVED, atau REJECTED',
    }),
});
