"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraPackageOrderValidation = void 0;
const zod_1 = require("zod");
class MitraPackageOrderValidation {
}
exports.MitraPackageOrderValidation = MitraPackageOrderValidation;
MitraPackageOrderValidation.CREATE = zod_1.z.object({
    mitra_package_id: zod_1.z.string({ message: 'ID paket mitra harus diisi' }),
});
MitraPackageOrderValidation.QUERY = zod_1.z.object({
    search: zod_1.z.string().optional(),
    sort: zod_1.z.string().optional(),
    order: zod_1.z.string().optional(),
    page: zod_1.z.number().int().min(1).default(1),
    limit: zod_1.z.number().int().min(1).max(100).default(10),
});
