"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExchangeRateValidation = void 0;
const zod_1 = require("zod");
class ExchangeRateValidation {
}
exports.ExchangeRateValidation = ExchangeRateValidation;
ExchangeRateValidation.CREATE = zod_1.z.object({
    currency: zod_1.z.string({ message: 'Mata uang harus diisi' }),
    rate_idr: zod_1.z.number().positive({ message: 'Nilai tukar tidak boleh negatif' }),
});
ExchangeRateValidation.BULK_UPDATE = zod_1.z.array(zod_1.z.object({
    id: zod_1.z.string({ message: 'ID tidak boleh kosong' }),
    currency: zod_1.z.string().optional(),
    rate_idr: zod_1.z.number().positive().optional(),
}));
