"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _a, _VendorService_checkVendorExist;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VendorService = void 0;
const uuid_1 = require("uuid");
const database_1 = require("../application/database");
const response_error_1 = require("../error/response-error");
const vendor_model_1 = require("../model/vendor-model");
const vendor_validation_1 = require("../validation/vendor-validation");
const validation_1 = require("../validation/validation");
class VendorService {
    static create(request) {
        return __awaiter(this, void 0, void 0, function* () {
            // Validate the create request
            const createRequest = validation_1.Validation.validate(vendor_validation_1.VendorValidation.CREATE, request);
            // Generate a UUID for the new vendor
            const vendorId = (0, uuid_1.v4)();
            // Insert the new vendor into the database with the UUID
            yield database_1.db.query('INSERT INTO vendor (id, name) VALUES (?, ?)', [vendorId, createRequest.name]);
            // Retrieve the newly created vendor by the UUID
            const vendor = yield database_1.db.queryOne('SELECT * FROM vendor WHERE id = ? LIMIT 1', [vendorId]);
            if (!vendor) {
                throw new response_error_1.ResponseError(500, 'Failed to create vendor');
            }
            return (0, vendor_model_1.toVendorResponse)(vendor);
        });
    }
    static update(id, request) {
        return __awaiter(this, void 0, void 0, function* () {
            // Validate the update request
            const updateRequest = validation_1.Validation.validate(vendor_validation_1.VendorValidation.UPDATE, request);
            // Check if the vendor exists
            yield __classPrivateFieldGet(this, _a, "m", _VendorService_checkVendorExist).call(this, id);
            // Update the vendor in the database
            yield database_1.db.query('UPDATE vendor SET name = ? WHERE id = ?', [updateRequest.name, id]);
            // Retrieve the updated vendor by the UUID
            const vendor = yield database_1.db.queryOne('SELECT * FROM vendor WHERE id = ? LIMIT 1', [id]);
            if (!vendor) {
                throw new response_error_1.ResponseError(500, 'Failed to update vendor');
            }
            return (0, vendor_model_1.toVendorResponse)(vendor);
        });
    }
    static delete(id) {
        return __awaiter(this, void 0, void 0, function* () {
            // Retrieve the vendor before deleting
            const vendor = yield database_1.db.queryOne('SELECT * FROM vendor WHERE id = ? LIMIT 1', [id]);
            if (!vendor) {
                throw new response_error_1.ResponseError(500, 'Failed to delete vendor');
            }
            // Delete the vendor from the database
            yield database_1.db.query('DELETE FROM vendor WHERE id = ?', [id]);
            return (0, vendor_model_1.toVendorResponse)(vendor);
        });
    }
    static getById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            // Retrieve a single vendor by ID
            const vendor = yield database_1.db.queryOne('SELECT * FROM vendor WHERE id = ? LIMIT 1', [id]);
            if (!vendor) {
                throw new response_error_1.ResponseError(404, 'Vendor not found');
            }
            return (0, vendor_model_1.toVendorResponse)(vendor);
        });
    }
    static getAll() {
        return __awaiter(this, void 0, void 0, function* () {
            // Retrieve all vendors from the database
            const vendors = yield database_1.db.query('SELECT * FROM vendor ORDER BY created_at ASC');
            // Map each vendor to the response format
            return vendors.map(vendor_model_1.toVendorResponse);
        });
    }
}
exports.VendorService = VendorService;
_a = VendorService, _VendorService_checkVendorExist = function _VendorService_checkVendorExist(id) {
    return __awaiter(this, void 0, void 0, function* () {
        // Check if the vendor exists
        const vendor = yield database_1.db.queryOne('SELECT id FROM vendor WHERE id = ? LIMIT 1', [id]);
        if (!vendor) {
            throw new response_error_1.ResponseError(404, 'Vendor not found');
        }
    });
};
