"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageTypeService = void 0;
const database_1 = require("../application/database");
const package_type_model_1 = require("../model/package-type-model");
class PackageTypeService {
    static getAll() {
        return __awaiter(this, void 0, void 0, function* () {
            // Get all package types from the database
            const packageTypes = yield database_1.db.query('SELECT * FROM package_type');
            // Map the package types to the response format
            return packageTypes.map(package_type_model_1.toPackageTypeResponse);
        });
    }
}
exports.PackageTypeService = PackageTypeService;
