"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraPackageOptionService = void 0;
const uuid_1 = require("uuid");
const database_1 = require("../application/database");
const mitra_package_option_model_1 = require("../model/mitra-package-option-model");
const mitra_package_option_validation_1 = require("../validation/mitra-package-option-validation");
const validation_1 = require("../validation/validation");
function bulkUpdate(table, request) {
    return __awaiter(this, void 0, void 0, function* () {
        // Validate the bulk update request
        const { created, modified, deleted } = validation_1.Validation.validate(mitra_package_option_validation_1.MitraPackageOptionValidation.BULK_UPDATE, request);
        // Start a transaction for batch processing
        yield database_1.db.transaction((conn) => __awaiter(this, void 0, void 0, function* () {
            // Inserting created items
            if (created && created.length > 0) {
                const values = created.map((option) => [(0, uuid_1.v4)(), option.name, option.price_idr, option.order_number]);
                const placeholders = values.map(() => '(?, ?, ?, ?)').join(', ');
                const query = `INSERT INTO ${table} (id, name, price_idr, order_number) VALUES ${placeholders}`;
                const flatValues = values.flat();
                yield conn.query(query, flatValues); // Use flat values
            }
            // Updating modified items
            if (modified && modified.length > 0) {
                yield Promise.all(modified.map((option) => __awaiter(this, void 0, void 0, function* () {
                    const query = `UPDATE ${table} SET name = ?, price_idr = ?, order_number = ? WHERE id = ?`;
                    yield conn.query(query, [option.name, option.price_idr, option.order_number, option.id]);
                })));
            }
            // Deleting items
            if (deleted && deleted.length > 0) {
                const query = `DELETE FROM ${table} WHERE id IN (?)`;
                yield conn.query(query, [deleted]);
            }
        }));
    });
}
function getAll(table) {
    return __awaiter(this, void 0, void 0, function* () {
        // Retrieve all items from the table
        const items = yield database_1.db.query(`SELECT * FROM ${table} ORDER BY order_number, created_at ASC`);
        // Map each item to the response format
        return items.map(mitra_package_option_model_1.toMitraPackageOptionResponse);
    });
}
class MitraPackageOptionService {
    // Airline methods
    static bulkUpdateAirlines(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('airline', request);
        });
    }
    static getAllAirlines() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('airline');
        });
    }
    // Visa methods
    static bulkUpdateVisas(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('visa', request);
        });
    }
    static getAllVisas() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('visa');
        });
    }
    // Transportation methods
    static bulkUpdateTransportations(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('transportation', request);
        });
    }
    static getAllTransportations() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('transportation');
        });
    }
    // Muthawif methods
    static bulkUpdateMuthawifs(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('muthawif', request);
        });
    }
    static getAllMuthawifs() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('muthawif');
        });
    }
    // Handling saudi methods
    static bulkUpdateHandlingSaudis(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('handling_saudi', request);
        });
    }
    static getAllHandlingSaudis() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('handling_saudi');
        });
    }
    // Hanlding domestic methods
    static bulkUpdateHandlingDomestics(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('handling_domestic', request);
        });
    }
    static getAllHandlingDomestics() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('handling_domestic');
        });
    }
    // Siskopatuh methods
    static bulkUpdateSiskopatuhs(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('siskopatuh', request);
        });
    }
    static getAllSiskopatuhs() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('siskopatuh');
        });
    }
    // Equipment methods
    static bulkUpdateEquipments(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('equipment', request);
        });
    }
    static getAllEquipments() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('equipment');
        });
    }
    // Tour plus methods
    static bulkUpdateTourPluses(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('tour_plus', request);
        });
    }
    static getAllTourPluses() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('tour_plus');
        });
    }
    // Manasik methods
    static bulkUpdateManasiks(request) {
        return __awaiter(this, void 0, void 0, function* () {
            yield bulkUpdate('manasik', request);
        });
    }
    static getAllManasiks() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getAll('manasik');
        });
    }
}
exports.MitraPackageOptionService = MitraPackageOptionService;
