"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authApi = void 0;
const express_1 = __importDefault(require("express"));
const auth_middleware_1 = require("../middleware/auth-middleware");
const multer_middleware_1 = require("../middleware/multer-middleware");
const permit_middleware_1 = require("../middleware/permit-middleware");
const auth_controller_1 = require("../controller/auth-controller");
const category_controller_1 = require("../controller/category-controller");
const contact_controller_1 = require("../controller/contact-controller");
const user_controller_1 = require("../controller/user-controller");
const exchange_rate_controller_1 = require("../controller/exchange-rate-controller");
const product_controller_1 = require("../controller/product-controller");
const product_order_controller_1 = require("../controller/product-order-controller");
const user_package_option_controller_1 = require("../controller/user-package-option-controller");
const user_package_order_controller_1 = require("../controller/user-package-order-controller");
const vendor_controller_1 = require("../controller/vendor-controller");
const hotel_controller_1 = require("../controller/hotel-controller");
const period_controller_1 = require("../controller/period-controller");
const mitra_package_option_controller_1 = require("../controller/mitra-package-option-controller");
const mitra_package_controller_1 = require("../controller/mitra-package-controller");
const mitra_package_order_controller_1 = require("../controller/mitra-package-order-controller");
const faq_controller_1 = require("../controller/faq-controller");
const content_controller_1 = require("../controller/content-controller");
const mitra_request_controller_1 = require("../controller/mitra-request-controller");
const menu_item_controller_1 = require("../controller/menu-item-controller");
const footer_controller_1 = require("../controller/footer-controller");
exports.authApi = express_1.default.Router();
exports.authApi.use(auth_middleware_1.authMiddleware);
// Authentication
exports.authApi.post('/v1/auth/logout', auth_controller_1.AuthController.logout);
// User
exports.authApi.post('/v1/users', (0, permit_middleware_1.permit)('ADMIN'), user_controller_1.UserController.create);
exports.authApi.get('/v1/users', (0, permit_middleware_1.permit)('ADMIN'), user_controller_1.UserController.getAll);
exports.authApi.get('/v1/users/current', user_controller_1.UserController.getCurrent);
exports.authApi.get('/v1/users/:id', (0, permit_middleware_1.permit)('ADMIN'), user_controller_1.UserController.get);
exports.authApi.patch('/v1/users/current', user_controller_1.UserController.updateCurrent);
exports.authApi.patch('/v1/users/current/password', user_controller_1.UserController.updateCurrentPassword);
exports.authApi.patch('/v1/users/:id', (0, permit_middleware_1.permit)('ADMIN'), user_controller_1.UserController.update);
exports.authApi.patch('/v1/users/upgrade/:id', user_controller_1.UserController.upgradeToMitra);
exports.authApi.delete('/v1/users/:id', (0, permit_middleware_1.permit)('ADMIN'), user_controller_1.UserController.delete);
// User Package Option
exports.authApi.post('/v1/user-package-options/bulk', (0, permit_middleware_1.permit)('ADMIN'), user_package_option_controller_1.UserPackageOptionController.bulkUpdate);
exports.authApi.get('/v1/user-package-options/:type', (0, permit_middleware_1.permit)('ADMIN'), user_package_option_controller_1.UserPackageOptionController.getByType);
// User Package Order
exports.authApi.get('/v1/user-package-orders', (0, permit_middleware_1.permit)('ADMIN'), user_package_order_controller_1.UserPackageOrderController.getAll);
exports.authApi.delete('/v1/user-package-orders/:id', (0, permit_middleware_1.permit)('ADMIN'), user_package_order_controller_1.UserPackageOrderController.delete);
// Category
exports.authApi.post('/v1/categories', (0, permit_middleware_1.permit)('ADMIN'), category_controller_1.CategoryController.create);
exports.authApi.put('/v1/categories/:id', (0, permit_middleware_1.permit)('ADMIN'), category_controller_1.CategoryController.update);
exports.authApi.delete('/v1/categories/:id', (0, permit_middleware_1.permit)('ADMIN'), category_controller_1.CategoryController.delete);
// Product
exports.authApi.post('/v1/products', (0, permit_middleware_1.permit)('ADMIN'), multer_middleware_1.upload.fields([{ name: 'thumbnails', maxCount: 3 }]), product_controller_1.ProductController.create);
exports.authApi.patch('/v1/products/:id', (0, permit_middleware_1.permit)('ADMIN'), multer_middleware_1.upload.fields([{ name: 'thumbnails', maxCount: 3 }]), product_controller_1.ProductController.update);
exports.authApi.delete('/v1/products/:id', (0, permit_middleware_1.permit)('ADMIN'), product_controller_1.ProductController.delete);
// Product Order
exports.authApi.get('/v1/product-orders', (0, permit_middleware_1.permit)('ADMIN'), product_order_controller_1.ProductOrderController.getAll);
exports.authApi.get('/v1/product-orders/user', product_order_controller_1.ProductOrderController.getAllByUser);
exports.authApi.get('/v1/product-orders/:id', (0, permit_middleware_1.permit)('ADMIN'), product_order_controller_1.ProductOrderController.get);
exports.authApi.delete('/v1/product-orders/:id', (0, permit_middleware_1.permit)('ADMIN'), product_order_controller_1.ProductOrderController.delete);
exports.authApi.post('/v1/product-orders', product_order_controller_1.ProductOrderController.create);
// Vendor
exports.authApi.post('/v1/vendors', (0, permit_middleware_1.permit)('ADMIN'), vendor_controller_1.VendorController.create);
exports.authApi.get('/v1/vendors', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), vendor_controller_1.VendorController.getAll);
exports.authApi.get('/v1/vendors/:id', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), vendor_controller_1.VendorController.getById);
exports.authApi.put('/v1/vendors/:id', (0, permit_middleware_1.permit)('ADMIN'), vendor_controller_1.VendorController.update);
exports.authApi.delete('/v1/vendors/:id', (0, permit_middleware_1.permit)('ADMIN'), vendor_controller_1.VendorController.delete);
// Hotel
exports.authApi.post('/v1/hotels', (0, permit_middleware_1.permit)('ADMIN'), hotel_controller_1.HotelController.create);
exports.authApi.get('/v1/hotels', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), hotel_controller_1.HotelController.getAll);
exports.authApi.get('/v1/hotels/:id', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), hotel_controller_1.HotelController.getById);
exports.authApi.put('/v1/hotels/:id', (0, permit_middleware_1.permit)('ADMIN'), hotel_controller_1.HotelController.update);
exports.authApi.post('/v1/hotels/bulk', (0, permit_middleware_1.permit)('ADMIN'), hotel_controller_1.HotelController.bulkUpdate);
exports.authApi.delete('/v1/hotels/:id', (0, permit_middleware_1.permit)('ADMIN'), hotel_controller_1.HotelController.delete);
// Period
exports.authApi.post('/v1/periods', (0, permit_middleware_1.permit)('ADMIN'), period_controller_1.PeriodController.create);
exports.authApi.get('/v1/periods', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), period_controller_1.PeriodController.getAll);
exports.authApi.get('/v1/periods/:id', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), period_controller_1.PeriodController.getById);
exports.authApi.put('/v1/periods/:id', (0, permit_middleware_1.permit)('ADMIN'), period_controller_1.PeriodController.update);
exports.authApi.delete('/v1/periods/:id', (0, permit_middleware_1.permit)('ADMIN'), period_controller_1.PeriodController.delete);
// Mitra Package Option
exports.authApi.post('/v1/mitra-packages/airlines/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateAirline);
exports.authApi.post('/v1/mitra-packages/visas/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateVisas);
exports.authApi.post('/v1/mitra-packages/transportations/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateTranportations);
exports.authApi.post('/v1/mitra-packages/muthawifs/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateMuthawifs);
exports.authApi.post('/v1/mitra-packages/handling-saudis/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateHandlingSaudis);
exports.authApi.post('/v1/mitra-packages/handling-domestics/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateHandlingDomestics);
exports.authApi.post('/v1/mitra-packages/siskopatuh/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateSiskopatuh);
exports.authApi.post('/v1/mitra-packages/equipments/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateEquipments);
exports.authApi.post('/v1/mitra-packages/tours/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateTourPluses);
exports.authApi.post('/v1/mitra-packages/manasik/bulk', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_option_controller_1.MitraPackageOptionController.bulkUpdateManasik);
exports.authApi.get('/v1/mitra-packages/airlines', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllAirlines);
exports.authApi.get('/v1/mitra-packages/visas', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllVisas);
exports.authApi.get('/v1/mitra-packages/transportations', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllTransportations);
exports.authApi.get('/v1/mitra-packages/muthawifs', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllMuthawifs);
exports.authApi.get('/v1/mitra-packages/handling-saudis', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllHandlingSaudis);
exports.authApi.get('/v1/mitra-packages/handling-domestics', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllHandlingDomestics);
exports.authApi.get('/v1/mitra-packages/siskopatuh', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllSiskopatuh);
exports.authApi.get('/v1/mitra-packages/equipments', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllEquipments);
exports.authApi.get('/v1/mitra-packages/tours', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllTourPluses);
exports.authApi.get('/v1/mitra-packages/manasik', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_option_controller_1.MitraPackageOptionController.getAllManasik);
// Exchange Rate
exports.authApi.post('/v1/exchange-rates', (0, permit_middleware_1.permit)('ADMIN'), exchange_rate_controller_1.ExchangeRateController.create);
exports.authApi.put('/v1/exchange-rates/', (0, permit_middleware_1.permit)('ADMIN'), exchange_rate_controller_1.ExchangeRateController.bulkUpdate);
exports.authApi.delete('/v1/exchange-rates/:id', (0, permit_middleware_1.permit)('ADMIN'), exchange_rate_controller_1.ExchangeRateController.delete);
// Contact
exports.authApi.post('/v1/contacts', (0, permit_middleware_1.permit)('ADMIN'), contact_controller_1.ContactController.create);
exports.authApi.put('/v1/contacts', (0, permit_middleware_1.permit)('ADMIN'), contact_controller_1.ContactController.bulkUpdate);
exports.authApi.delete('/v1/contacts/:id', (0, permit_middleware_1.permit)('ADMIN'), contact_controller_1.ContactController.delete);
// Mitra Package
exports.authApi.post('/v1/mitra-packages', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_controller_1.MitraPackageController.create);
exports.authApi.get('/v1/mitra-packages/:id', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_controller_1.MitraPackageController.get);
// Mitra Package Order
exports.authApi.post('/v1/mitra-package-orders', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_order_controller_1.MitraPackageOrderController.create);
exports.authApi.get('/v1/mitra-package-orders', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_order_controller_1.MitraPackageOrderController.getAll);
exports.authApi.get('/v1/mitra-package-orders/user', (0, permit_middleware_1.permit)('ADMIN', 'MITRA'), mitra_package_order_controller_1.MitraPackageOrderController.getAllByUser);
exports.authApi.delete('/v1/mitra-package-orders/:id', (0, permit_middleware_1.permit)('ADMIN'), mitra_package_order_controller_1.MitraPackageOrderController.delete);
// Mitra Request
exports.authApi.post('/v1/mitra-requests', (0, permit_middleware_1.permit)('USER'), multer_middleware_1.upload.fields([
    { name: 'ktp', maxCount: 1 },
    { name: 'payment', maxCount: 1 },
]), mitra_request_controller_1.MitraRequestController.create);
exports.authApi.get('/v1/mitra-requests/status', (0, permit_middleware_1.permit)('USER', 'ADMIN'), mitra_request_controller_1.MitraRequestController.getStatusByUser);
exports.authApi.get('/v1/mitra-requests', (0, permit_middleware_1.permit)('ADMIN'), mitra_request_controller_1.MitraRequestController.getAll);
exports.authApi.patch('/v1/mitra-requests/:id', (0, permit_middleware_1.permit)('ADMIN'), mitra_request_controller_1.MitraRequestController.updateStatus);
exports.authApi.delete('/v1/mitra-requests/:id', (0, permit_middleware_1.permit)('ADMIN'), mitra_request_controller_1.MitraRequestController.delete);
// Faq
exports.authApi.post('/v1/faqs', (0, permit_middleware_1.permit)('ADMIN'), faq_controller_1.FaqController.create);
exports.authApi.put('/v1/faqs/:id', (0, permit_middleware_1.permit)('ADMIN'), faq_controller_1.FaqController.update);
exports.authApi.delete('/v1/faqs/:id', (0, permit_middleware_1.permit)('ADMIN'), faq_controller_1.FaqController.delete);
// Content
exports.authApi.post('/v1/contents', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.create);
exports.authApi.post('/v1/contents/colors', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.createColor);
exports.authApi.patch('/v1/contents/colors', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.updateColors);
exports.authApi.delete('/v1/contents/colors/:id', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.deleteColor);
exports.authApi.put('/v1/contents/:id', (0, permit_middleware_1.permit)('ADMIN'), multer_middleware_1.upload.single('content'), content_controller_1.ContentController.update);
exports.authApi.patch('/v1/contents/:id', (0, permit_middleware_1.permit)('ADMIN'), multer_middleware_1.upload.single('content'), content_controller_1.ContentController.updateValue);
exports.authApi.patch('/v1/contents/:id/visibility', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.updateVisibility);
exports.authApi.delete('/v1/contents/:id', (0, permit_middleware_1.permit)('ADMIN'), content_controller_1.ContentController.delete);
// Menu Item
exports.authApi.post('/v1/menu-items', (0, permit_middleware_1.permit)('ADMIN'), menu_item_controller_1.MenuItemController.create);
exports.authApi.patch('/v1/menu-items/:id', (0, permit_middleware_1.permit)('ADMIN'), menu_item_controller_1.MenuItemController.update);
exports.authApi.patch('/v1/menu-items/:id/visibility', (0, permit_middleware_1.permit)('ADMIN'), menu_item_controller_1.MenuItemController.updateVisibility);
exports.authApi.delete('/v1/menu-items/:id', (0, permit_middleware_1.permit)('ADMIN'), menu_item_controller_1.MenuItemController.delete);
// Footer
exports.authApi.post('/v1/footers', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.create);
exports.authApi.post('/v1/footers/:footerId/items', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.createItem);
exports.authApi.patch('/v1/footers/orders', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.updateOrder);
exports.authApi.patch('/v1/footers/:id', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.update);
exports.authApi.patch('/v1/footers/:footerId/items/:itemId', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.updateItem);
exports.authApi.patch('/v1/footers/:id/visibility', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.updateVisibility);
exports.authApi.patch('/v1/footers/:footerId/items/:itemId/visibility', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.updateItemVisibility);
exports.authApi.delete('/v1/footers/:id', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.delete);
exports.authApi.delete('/v1/footers/:footerId/items/:itemId', (0, permit_middleware_1.permit)('ADMIN'), footer_controller_1.FooterController.deleteItem);
