"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toProductOrderResponse = toProductOrderResponse;
const user_model_1 = require("./user-model");
function toProductOrderResponse(productOrder) {
    var _a;
    console.log(productOrder);
    return {
        id: productOrder.id,
        user: (0, user_model_1.toUserResponse)(productOrder.user),
        product_id: productOrder.product_id,
        product_name: productOrder.product.name,
        variation: (_a = productOrder.productVariation) !== null && _a !== void 0 ? _a : null,
        departure: productOrder.departure,
        number_of_pax: productOrder.number_of_pax,
        per_pax_price: Number(productOrder.per_pax_price.toString()),
        total_price: Number(productOrder.total_price.toString()),
        created_at: productOrder.created_at,
        updated_at: productOrder.updated_at,
    };
}
