"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toProductResponse = toProductResponse;
function toProductResponse(product) {
    var _a;
    return {
        id: product.id,
        name: product.name,
        description: (_a = product.description) !== null && _a !== void 0 ? _a : '',
        price: product.price,
        has_variation: product.has_variation,
        thumbnails: product.ProductThumbnails.map((thumbnail) => ({
            id: thumbnail.id,
            image_url: thumbnail.image_url,
        })),
        categories: product.ProductCategories.map((category) => ({
            id: category.Category.id,
            name: category.Category.name,
        })),
        variations: product.ProductVariations.map((variation) => ({
            id: variation.id,
            name: variation.name,
            price: variation.price,
        })),
        includes: product.ProductIncludes.map((include) => ({
            id: include.id,
            description: include.description,
        })),
        excludes: product.ProductExcludes.map((exclude) => ({
            id: exclude.id,
            description: exclude.description,
        })),
        created_at: product.created_at,
        updated_at: product.updated_at,
    };
}
