"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.permit = void 0;
const response_error_1 = require("../error/response-error");
const permit = (...roles) => {
    return (req, res, next) => {
        const user = req.user;
        if (!user) {
            return next(new response_error_1.ResponseError(401, 'Unauthorized'));
        }
        if (!roles.includes(user.role)) {
            return next(new response_error_1.ResponseError(403, 'Forbidden'));
        }
        next();
    };
};
exports.permit = permit;
