"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPackageOrderController = void 0;
const user_package_order_service_1 = require("../service/user-package-order-service");
class UserPackageOrderController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield user_package_order_service_1.UserPackageOrderService.create(request);
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil dipesan',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    search: req.query.search,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: req.query.page ? Number(req.query.page) : 1,
                    limit: req.query.limit ? Number(req.query.limit) : 10,
                };
                const response = yield user_package_order_service_1.UserPackageOrderService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil didapatkan',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const { id } = req.params;
                yield user_package_order_service_1.UserPackageOrderService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Paket user berhasil dihapus',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.UserPackageOrderController = UserPackageOrderController;
