"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MitraPackageOrderController = void 0;
const mitra_package_order_service_1 = require("../service/mitra-package-order-service");
class MitraPackageOrderController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield mitra_package_order_service_1.MitraPackageOrderService.create(req.user, request);
                res.status(201).json({
                    success: true,
                    message: 'Mitra package order created successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    search: req.query.search,
                    sort: req.query.sort,
                    order: req.query.order,
                    page: req.query.page ? Number(req.query.page) : 1,
                    limit: req.query.limit ? Number(req.query.limit) : 10,
                };
                const result = yield mitra_package_order_service_1.MitraPackageOrderService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'Mitra package order list',
                    data: result,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllByUser(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const result = yield mitra_package_order_service_1.MitraPackageOrderService.getAllByUser(req.user);
                res.status(200).json({
                    success: true,
                    message: 'Mitra package order list',
                    data: result,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const result = yield mitra_package_order_service_1.MitraPackageOrderService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Mitra package order retrieved successfully',
                    data: result,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield mitra_package_order_service_1.MitraPackageOrderService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Mitra package order deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.MitraPackageOrderController = MitraPackageOrderController;
