"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuItemController = void 0;
const menu_item_service_1 = require("../service/menu-item-service");
class MenuItemController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield menu_item_service_1.MenuItemService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Menu item created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield menu_item_service_1.MenuItemService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Menu items retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield menu_item_service_1.MenuItemService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Menu item retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = req.body;
                const response = yield menu_item_service_1.MenuItemService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Menu item updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateVisibility(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const visible = req.body.visible;
                const response = yield menu_item_service_1.MenuItemService.updateVisibility(id, visible);
                res.status(200).json({
                    success: true,
                    message: 'Menu item visibility updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield menu_item_service_1.MenuItemService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Menu item deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.MenuItemController = MenuItemController;
