"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HotelController = void 0;
const hotel_service_1 = require("../service/hotel-service");
class HotelController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield hotel_service_1.HotelService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Hotel created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = req.body;
                // const response = await HotelService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Hotel updated successfully',
                    // data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdate(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield hotel_service_1.HotelService.bulkUpdate(request);
                res.status(200).json({
                    success: true,
                    message: 'Hotels updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield hotel_service_1.HotelService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Hotel deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getById(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield hotel_service_1.HotelService.getById(id);
                res.status(200).json({
                    success: true,
                    message: 'Hotel retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const query = {
                    vendor_id: req.query.vendor_id,
                    period_id: req.query.period_id,
                    city: req.query.city,
                };
                const response = yield hotel_service_1.HotelService.getAll(query);
                res.status(200).json({
                    success: true,
                    message: 'Hotels retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAllHotelPeriodPrices(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield hotel_service_1.HotelService.getAllHotelPeriodPrices();
                res.status(200).json({
                    success: true,
                    message: 'Hotel period prices retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.HotelController = HotelController;
