"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FooterController = void 0;
const footer_service_1 = require("../service/footer-service");
class FooterController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield footer_service_1.FooterService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Footer created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield footer_service_1.FooterService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Footers retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield footer_service_1.FooterService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Footer retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static update(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const request = req.body;
                const response = yield footer_service_1.FooterService.update(id, request);
                res.status(200).json({
                    success: true,
                    message: 'Footer updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateVisibility(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const visible = req.body.visible;
                const response = yield footer_service_1.FooterService.updateVisibility(id, visible);
                res.status(200).json({
                    success: true,
                    message: 'Footer visibility updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateOrder(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield footer_service_1.FooterService.updateOrder(request);
                res.status(200).json({
                    success: true,
                    message: 'Footer order updated successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield footer_service_1.FooterService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Footer deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static createItem(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const footerId = req.params.footerId;
                const request = req.body;
                const response = yield footer_service_1.FooterService.createItem(footerId, request);
                res.status(201).json({
                    success: true,
                    message: 'Footer item created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateItem(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const footerId = req.params.footerId;
                const itemId = req.params.itemId;
                const request = req.body;
                const response = yield footer_service_1.FooterService.updateItem(footerId, itemId, request);
                res.status(200).json({
                    success: true,
                    message: 'Footer item updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static updateItemVisibility(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const footerId = req.params.footerId;
                const itemId = req.params.itemId;
                const visible = req.body.visible;
                const response = yield footer_service_1.FooterService.updateItemVisibility(footerId, itemId, visible);
                res.status(200).json({
                    success: true,
                    message: 'Footer item visibility updated successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static deleteItem(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const footerId = req.params.footerId;
                const itemId = req.params.itemId;
                yield footer_service_1.FooterService.deleteItem(footerId, itemId);
                res.status(200).json({
                    success: true,
                    message: 'Footer item deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.FooterController = FooterController;
