"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExchangeRateController = void 0;
const exchange_rate_service_1 = require("../service/exchange-rate-service");
class ExchangeRateController {
    static create(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                const response = yield exchange_rate_service_1.ExchangeRateService.create(request);
                res.status(201).json({
                    success: true,
                    message: 'Exchange rate created successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static bulkUpdate(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const request = req.body;
                yield exchange_rate_service_1.ExchangeRateService.bulkUpdate(request);
                res.status(200).json({
                    success: true,
                    message: 'Exchange rates updated successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static delete(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                yield exchange_rate_service_1.ExchangeRateService.delete(id);
                res.status(200).json({
                    success: true,
                    message: 'Exchange rate deleted successfully',
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static getAll(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield exchange_rate_service_1.ExchangeRateService.getAll();
                res.status(200).json({
                    success: true,
                    message: 'Exchange rates retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
    static get(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const id = req.params.id;
                const response = yield exchange_rate_service_1.ExchangeRateService.get(id);
                res.status(200).json({
                    success: true,
                    message: 'Exchange rate retrieved successfully',
                    data: response,
                });
            }
            catch (error) {
                next(error);
            }
        });
    }
}
exports.ExchangeRateController = ExchangeRateController;
