"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.web = void 0;
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const cors_1 = __importDefault(require("cors"));
const express_1 = __importDefault(require("express"));
const public_api_1 = require("../route/public-api");
const auth_api_1 = require("../route/auth-api");
const error_middleware_1 = require("../middleware/error-middleware");
exports.web = (0, express_1.default)();
exports.web.use(express_1.default.json());
exports.web.use('/public', express_1.default.static('public'));
exports.web.use((0, cors_1.default)({ origin: process.env.CORS_ORIGIN, credentials: true }));
exports.web.use((0, cookie_parser_1.default)());
exports.web.use(public_api_1.publicRouter);
exports.web.use(auth_api_1.authApi);
exports.web.use(error_middleware_1.errorMiddleware);
exports.web.get('/', (req, res) => {
    res.send('Hello World');
});
